/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.taskcontroller;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerListener;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager;
import com.ibm.hwmca.fw.servlet.util.WindowOptions;
import com.ibm.hwmca.fw.servlet.util.WorkQueue;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TaskControllerQueue
extends WorkQueue {
    public static final String TRACE_MASKT = "HTSKCTLT";
    public static final String TRACE_MASKF = "HTSKCTLF";
    public static final String TRACE_MASKD = "HTSKCTLD";
    private static final String WORK_QUEUE_KEY = "taskController.queue";
    private static final String THIS_CLASS = "TaskControllerQueue";
    private static int REFRESH_COUNT = 0;
    public static final WindowOptions DEFAULT_WINDOW_OPTIONS = new WindowOptions();
    private static final String WINDOW_OPTIONS_FILE_NAME = "TaskWindow.properties";
    private static final String OPEN = "('";
    private static final String CLOSE = "');";
    private static final String COMMA = "', '";
    public static final String URL_PREFIX = "/content?taskId=";
    public static final String WINDOW_OPTIONS_KEY = "taskController.window_options";
    private Set _tasksWithPendingUpdates;
    private Object pendingUpdatesLock = new Object();
    private HMCSession _hmcSession;
    private Listener listener;
    protected List _taskControllerListeners;
    private int servletThreadInstance = -1;

    public static synchronized TaskControllerQueue getTaskControllerQueue(HMCSession session) {
        TaskControllerQueue queue = (TaskControllerQueue)session.getSessionAttribute(WORK_QUEUE_KEY);
        if (queue == null) {
            Trace.trace(TRACE_MASKF, "TaskControllerQueue.getTaskControllerQueue:  creating new queue for HMC session with id " + session.getSessionId());
            queue = new TaskControllerQueue(session);
        }
        return queue;
    }

    public static String getUrl(PanelModelTaskPortal task) {
        return ServletRuntime.getRuntime().getHMCContextPath() + URL_PREFIX + task.getTaskId();
    }

    private TaskControllerQueue(HMCSession hmcSession) {
        this._hmcSession = hmcSession;
        this.listener = new Listener();
        this._hmcSession.addHMCSessionListener(this.listener);
        this._hmcSession.setSessionAttribute(WORK_QUEUE_KEY, this);
        this._tasksWithPendingUpdates = new HashSet();
        this._taskControllerListeners = new ArrayList();
    }

    public synchronized void addTaskControllerListener(TaskControllerListener listener) {
        this._taskControllerListeners.add(listener);
    }

    public synchronized void removeTaskControllerListener(TaskControllerListener listener) {
        this._taskControllerListeners.remove(listener);
    }

    synchronized void connectToServlet(int servletThreadInstance) {
        if (!this.isValid()) {
            return;
        }
        int priorServletInstanceId = this.servletThreadInstance;
        this.servletThreadInstance = servletThreadInstance;
        Trace.trace(TRACE_MASKT, "TaskControllerQueue " + this + " now connected to servlet thread instance id " + servletThreadInstance);
        if (priorServletInstanceId == -1) {
            this.fireTaskControllerConnectedEvent();
        } else {
            this.notifyAll();
        }
    }

    synchronized void disconnectFromServlet(int servletThreadInstance, Throwable e) {
        if (servletThreadInstance != this.servletThreadInstance) {
            return;
        }
        this.servletThreadInstance = -1;
        Trace.trace(TRACE_MASKT, "TaskControllerQueue " + this + " disconnecting from servlet thread instance id " + servletThreadInstance);
        this.fireTaskControllerDisconnectedEvent(e);
    }

    synchronized int getConnectedServlet() {
        return this.servletThreadInstance;
    }

    private synchronized void fireTaskControllerConnectedEvent() {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.fireTaskControllerConnectedEvent:  ");
        Iterator iterator = new ArrayList(this._taskControllerListeners).iterator();
        while (iterator.hasNext()) {
            TaskControllerListener listener = (TaskControllerListener)iterator.next();
            listener.taskControllerConnected(this._hmcSession);
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.fireTaskControllerConnectedEvent:  ");
    }

    private synchronized void fireTaskControllerDisconnectedEvent(Throwable e) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.fireTaskControllerDisconnectedEvent:  " + e);
        Iterator iterator = new ArrayList(this._taskControllerListeners).iterator();
        while (iterator.hasNext()) {
            TaskControllerListener listener = (TaskControllerListener)iterator.next();
            listener.taskControllerDisconnected(this._hmcSession, e);
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.fireTaskControllerDisconnectedEvent:  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean resendUpdates(int servletThreadInstance) {
        if (this._hmcSession.isDisconnected() || servletThreadInstance != this.servletThreadInstance) {
            return false;
        }
        Object object = this.pendingUpdatesLock;
        synchronized (object) {
            if (this._tasksWithPendingUpdates.isEmpty()) {
                return false;
            }
            Iterator i = this._tasksWithPendingUpdates.iterator();
            while (i.hasNext()) {
                String taskId = (String)i.next();
                PanelModelTaskPortal task = this._hmcSession.getPanelModelTaskPortal(taskId);
                if (task != null) {
                    this.refresh(task);
                    continue;
                }
                i.remove();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromHistory(String taskID) {
        Object object = this.pendingUpdatesLock;
        synchronized (object) {
            this._tasksWithPendingUpdates.remove(taskID);
        }
    }

    public synchronized String pullScript(int msecs, int servletThreadInstance) {
        while (this.servletThreadInstance == servletThreadInstance) {
            if (!this.isValid()) {
                return null;
            }
            try {
                return (String)this.pull(msecs);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return null;
    }

    public void invalidate() {
        Trace.trace(TRACE_MASKF, "TaskControllerQueue.invalidate:  ");
        super.invalidate();
    }

    public void sendScript(String script) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push("<SCRIPT language='JavaScript'> try {connectedToServer=true;" + script + "} catch (tcqe) {} </SCRIPT>");
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    public void sendDisconnectedScript(String script) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendDisconnectedScript:  " + script);
        this.push("<SCRIPT language='JavaScript'> try {connectedToServer=true;" + script + "} catch (tcqe) {} </SCRIPT>");
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendScript(String script, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push("<SCRIPT language='JavaScript'> try {connectedToServer=true;" + script + "} catch (tcqe) {} </SCRIPT>");
        Object object = this.pendingUpdatesLock;
        synchronized (object) {
            this._tasksWithPendingUpdates.add(task.getTaskId());
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRawScript(String script, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendRawScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push(script);
        Object object = this.pendingUpdatesLock;
        synchronized (object) {
            this._tasksWithPendingUpdates.add(task.getTaskId());
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendRawScript:  ");
    }

    public void callTaskWindowFunction(String functionCall, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScriptToTaskWindow");
        this.sendScript("window.open( '', '" + task.getWindowName() + "')." + functionCall, task);
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScriptToTaskWindow");
    }

    public void openWindow(PanelModelTaskPortal task) {
        this.openWindow(task, DEFAULT_WINDOW_OPTIONS);
    }

    public void openWindow(PanelModelTaskPortal task, WindowOptions options) {
        this.openWindow(TaskControllerQueue.getUrl(task), task.getWindowName(), options, task);
        task.setAttribute(WINDOW_OPTIONS_KEY, options);
    }

    public void openWindow(String url, String name, WindowOptions options, PanelModelTaskPortal task) {
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring openWindow request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        task.setWindowOpen(true);
        this.sendScript("openWindow('" + url + COMMA + name + COMMA + options + COMMA + this.getRelativeWidth(options) + COMMA + this.getRelativeHeight(options) + CLOSE, task);
    }

    public void refresh(PanelModelTaskPortal task) {
        this.refresh(task.getWindowName(), TaskControllerQueue.getUrl(task) + "&refresh=" + REFRESH_COUNT++, TaskControllerQueue.getWindowOptionsForTask(task), task, false);
    }

    public void refresh(String name, String url, WindowOptions options, PanelModelTaskPortal task) {
        this.refresh(name, url, options, task, false);
    }

    public void refresh(PanelModelTaskPortal task, boolean focus) {
        this.refresh(task.getWindowName(), TaskControllerQueue.getUrl(task) + "&refresh=" + REFRESH_COUNT++, TaskControllerQueue.getWindowOptionsForTask(task), task, focus);
    }

    public void refresh(String name, String url, WindowOptions options, PanelModelTaskPortal task, boolean focus) {
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring refresh request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        task.setWindowOpen(true);
        this.sendScript("refreshWindow('" + name + COMMA + url + COMMA + options + COMMA + this.getRelativeWidth(options) + COMMA + this.getRelativeHeight(options) + COMMA + (focus ? "true" : "false") + CLOSE, task);
    }

    private Integer getRelativeWidth(WindowOptions options) {
        Integer relativeWidth = options.getRelativeWidth();
        if (relativeWidth == null) {
            relativeWidth = new Integer(0);
        }
        return relativeWidth;
    }

    private Integer getRelativeHeight(WindowOptions options) {
        Integer relativeHeight = options.getRelativeHeight();
        if (relativeHeight == null) {
            relativeHeight = new Integer(0);
        }
        return relativeHeight;
    }

    public static WindowOptions getWindowOptionsForTask(PanelModelTaskPortal task) {
        WindowOptions options = (WindowOptions)task.getAttribute(WINDOW_OPTIONS_KEY);
        if (options == null) {
            options = (WindowOptions)DEFAULT_WINDOW_OPTIONS.clone();
            task.setAttribute(WINDOW_OPTIONS_KEY, DEFAULT_WINDOW_OPTIONS);
        }
        Dimension windowSize = task.getWindowSize();
        options.setWidth(windowSize.width);
        options.setHeight(windowSize.height);
        TaskWindowPositionManager.WindowPosition winPos = task.getWindowPosition();
        options.setScreenX(winPos.getX());
        options.setScreenY(winPos.getY());
        return options;
    }

    static {
        Properties options = new Properties();
        String propsFileName = "";
        try {
            propsFileName = BaseFileControl.getFilePath(WINDOW_OPTIONS_FILE_NAME) + WINDOW_OPTIONS_FILE_NAME;
            options.load(new FileInputStream(propsFileName));
            DEFAULT_WINDOW_OPTIONS.putProperties(options);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  Some of the options specified in " + propsFileName + " are invalid.");
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  " + e.getMessage());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  The windows options file, " + propsFileName + ", was not found.");
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  " + e.getMessage(), e);
            DEFAULT_WINDOW_OPTIONS.setLocation(false);
            DEFAULT_WINDOW_OPTIONS.setMenubar(false);
            DEFAULT_WINDOW_OPTIONS.setScrollbars(true);
            DEFAULT_WINDOW_OPTIONS.setToolbar(false);
            DEFAULT_WINDOW_OPTIONS.setWidth(640);
            DEFAULT_WINDOW_OPTIONS.setHeight(480);
            DEFAULT_WINDOW_OPTIONS.setResizable(true);
        }
    }

    private class Listener
    implements HMCSessionListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDisconnected(HMCSession session) {
            Object object = TaskControllerQueue.this.pendingUpdatesLock;
            synchronized (object) {
                TaskControllerQueue.this._tasksWithPendingUpdates.clear();
            }
        }

        public void sessionConnected(HMCSession session) {
        }

        public void sessionDestroyed(HMCSession session) {
            Thread invalidateThread = new Thread("TaskControllerQueue invalidation"){

                public void run() {
                    TaskControllerQueue.this.invalidate();
                }
            };
            invalidateThread.setDaemon(true);
            invalidateThread.start();
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(HMCSession session) {
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }
    }
}

